#!/usr/bin/env python

from gtk import *
from gnome.zvt import *
import ConfigParser
import libglade, dircache 
import DiscID, CDDB, sys, os, popen2
from string import *
PREFIX = '%%prefix%%'

# We put all of our gtk signal handlers into a class.  This lets us bind
# all of them at once, because their names are in the class dict.

class GladeHandlers:
	def on_Xpand_destroy(event):
		save_config()
		os.system('rm -f %s/temp.wav' % (config_dict['dest_dir']))
		mainquit()
	def on_quit_released(event):
		save_config()
		os.system('rm -f %s/temp.wav' % (config_dict['dest_dir']))
		mainquit()
	def on_MP3radio_pressed(event):
		widgets["frame3"].set_sensitive(TRUE)
		clear_list()
		populate_mp3music_list(widgets['source_dir'].get_text())
	def on_CDradio_released(event):
		widgets["frame3"].set_sensitive(FALSE)
		clear_list()
		message_text = 'Getting CD info...\r\n'
		term.feed(message_text)
		populate_cdmusic_list()
	def on_normalize_clicked(event):
		if widgets['normalize'].get_active():
			widgets["compress"].set_sensitive(TRUE)
		else:
			widgets["compress"].set_sensitive(FALSE)
	def on_dev_path_changed(event):
		config_dict['dev_path'] = widgets["dev_path"].get_text()
	def on_source_dir_changed(event):
		clear_list()
		source_dir= widgets['source_dir'].get_text()
		if source_dir[-1] == '/':
			widgets['source_dir'].set_text(source_dir[:-1])
		config_dict['source_dir'] = widgets['source_dir'].get_text()
		populate_mp3music_list(widgets['source_dir'].get_text())
	def on_dest_dir_changed(event):
		dest_dir= widgets['dest_dir'].get_text()
		if dest_dir[-1] == '/':
			widgets['dest_dir'].set_text(dest_dir[:-1])
		config_dict['dest_dir'] = widgets['dest_dir'].get_text()
	def on_selectall_released(event):
		widgets["list1"].select_all()
	def on_clear_released(event):
		widgets["list1"].unselect_all()
	def on_ok_released(event):
		widgets["ok"].set_sensitive(FALSE)
		create_mp3s()	
	def on_list1_selection_changed(event):
		widgets["ok"].set_sensitive(TRUE)
	def on_preset_toggled(event):
		set_levels(event)
	def on_spinbutton_changed(event):
		on_sbutton_changed(event)
	
class WidgetsWrapper:
	def __init__(self):
		self.widgets = libglade.GladeXML (PREFIX + '/share/xpand/xpand.glade', "Xpand")
		self.widgets.signal_autoconnect(GladeHandlers.__dict__)
	# Gives us the ability to do: widgets['widget_name'].action()
	def __getitem__(self, key):
		return self.widgets.get_widget(key)

def on_sbutton_changed(button):
	value=[]
	global preset_name
	compress_values = ""
	for n in range(11):
			value.append(sbutton[n].get_value())
			compress_values = compress_values + str(int(sbutton[n].get_value())) + ','
	attack = str(round(widgets['spinbutton1'].get_value(),3)) 
	decay = str(round(widgets['spinbutton2'].get_value(),1))
	postprocess = str(int(widgets['spinbutton3'].get_value()))
	initial = str(int(widgets['spinbutton4'].get_value()))
	config_dict[preset_name] = compress_values + attack + ',' + decay + ',' + postprocess + ',' + initial
		
def clear_list():
	num= len(widgets["list1"].children())
	widgets["list1"].clear_items(0,num)
	
def populate_mp3music_list(source_dir):
	widgets["list1"].clear_items(0,-1)
	list_items = dircache.listdir(source_dir)
	dircache.annotate(source_dir, list_items)
	for i in list_items:
		if i[-4:] == ".mp3" or i[-4:] == ".wav":
			list_item = GtkListItem(i)
			widgets["list1"].add(list_item)
			list_item.show()
		
			
def output_message(message_text):
	widgets["entry2"].set_text(message_text)
def populate_cdmusic_list():
	fd = os.fdopen(os.open(config_dict['dev_path'], os.O_RDONLY | os.O_NONBLOCK))
	try:
		disc_id = DiscID.disc_id(fd)
		(query_stat, query_info) = CDDB.query(disc_id, server_url='http://freedb.freedb.org/~cddb/cddb.cgi')
	except:
		message_text= 'Could not get CD info.  Check if CD is in.\n\r'
		term.feed(message_text)
		return
	if query_stat == 200:
		atl = split(query_info['title'], '/')
		artist = strip(atl[0])
		title = strip(atl[1])
		(read_stat, read_info) = CDDB.read(query_info['category'], query_info['disc_id'])
		if read_stat == 210:
			track_list = []
			for i in range(disc_id[1]):
				track_list.append(read_info['TTITLE' + `i`])	
		else:
			no_cddb(disc_id)
			term.feed('Failure getting track info from CDDB, status: %i\n\r' % (read_stat))
			term.feed('This CD may not be in the database.\n\r')
			term.feed('Edit the filenames when finished.\n\r')
			return
	elif query_stat == 210 or query_stat == 211:
		query_info = query_info[0]
		atl = split(query_info['title'], '/')
		artist = strip(atl[0])
		title = strip(atl[1])
		(read_stat, read_info) = CDDB.read(query_info['category'], query_info['disc_id'])
		if read_stat == 210:
			track_list = []
			for i in range(disc_id[1]):
				track_list.append(read_info['TTITLE' + `i`])	
		else:
			no_cddb(disc_id)
			term.feed('Failure getting track info from CDDB, status: %i\n\r' % (read_stat))
			term.feed('This CD may not be in the database.\n\r')
			term.feed('Edit the filenames when finished.\n\r')
	else:
		no_cddb(disc_id)
		term.feed('Failure getting track info from CDDB, status: %i\n\r' % (query_stat))
		term.feed('This CD may not be in the database.\n\r')
		term.feed('Edit the filenames when finished.\n\r')
		return

	for n in range( len(track_list) ):
		track_list[n] = replace(track_list[n], '/', '-')
		track_list[n] = replace(track_list[n], '\\', ' ')
		track_list[n] = replace(track_list[n], '?', '')
		track_list[n] = replace(track_list[n], '"', '')
		track_list[n] = replace(track_list[n], ':', ' -')
		track_list[n] = replace(track_list[n], "'", '')	
		track_list[n] = replace(track_list[n], '`', '')
	for num in range(len(track_list)): 
		list_item = GtkListItem('%d. %s' % (num + 1, track_list[num]))
		widgets["list1"].add(list_item)
		list_item.show()	
	message_text = 'Successful\n\r\n\r' 
	term.feed(message_text)

def create_mp3s():
	compress_levels = []
	for n in range(10, -1, -1):
		value = str(-int(sbutton[10-n].get_value()))
		compress_levels.append(value)
	mp3_format=str(widgets["mp3_format"].get_active())
	compress=str(widgets["compress"].get_active())
	normalize=str(widgets["normalize"].get_active())
	verbose='1'
	# create a list of selected music	
	rip="1"
	if widgets["MP3radio"].get_active():
		rip="0"
	rip_list = widgets["list1"].get_selection()
	
	if len(rip_list) < 1:
		message_text = 'Make a selection\n\r'
		term.feed(message_text)
		return			
	dest_dir = widgets['dest_dir'].get_text()
	source_dir = widgets['source_dir'].get_text()

	# make the arg list to pass to the forked process, arg_list = args + compress_levels + rip_list
	arg_list = ['compand.py', config_dict['source_dir'], mp3_format, config_dict['dev_path'], config_dict['dest_dir'], rip, verbose, compress, normalize]
	arg_list = arg_list + compress_levels 
	for w in rip_list:
		track = w.children()[0].get()
		#print track
		arg_list.append(track)
	pid = term.forkpty()
	if pid == -1:
		term.feed("Couldn't fork\n\r")
		return
	if pid == 0:
		os.execv(PREFIX + '/share/xpand/compand.py', arg_list)
		
def no_cddb(disc_id):
	for num in range(disc_id[1]):
		list_item = GtkListItem('%d. %s' % (num + 1, 'Track ' + str((num + 1))))
		widgets["list1"].add(list_item)
		list_item.show()	
		
def set_levels(button):	
	if button.get_active():
		# name = the name of the widget and the key in the config_dict dictionary
		name = libglade.get_widget_name(button)
		global preset_name
		preset_name = name
		widgets['frame8'].set_sensitive(TRUE)
		widgets['hbox11'].set_sensitive(TRUE)
		if preset_name == "defaults":
			widgets['frame8'].set_sensitive(FALSE)
			widgets['hbox11'].set_sensitive(FALSE)
		value = split(config_dict[preset_name],',')
		for n in range(11):	
			adjustments[n].set_value((int(value[n])))
		attack = float(value[11])
		decay = float(value[12])
		postprocess =  int(value[13])
		initial = int(value[14])
		compress_levels = value[11] + ',' + value[12] + ' ' 
		for n in range(10):
			compress_levels=compress_levels + str(10*(10-n)) + ',' + value[n] + ',' 
		compress_levels = compress_levels + '0,0 ' + value[13] + ' ' + value[14]	
		widgets['spinbutton1'].set_value(attack)
		widgets['spinbutton2'].set_value(decay)
		widgets['spinbutton3'].set_value(postprocess)
		widgets['spinbutton4'].set_value(initial)
		
def save_config():
	config_dict['source_dir'] = widgets['source_dir'].get_text()
	config_dict['dest_dir'] = widgets['dest_dir'].get_text()
	config_dict['dev_path'] = widgets['dev_path'].get_text()
	config_list = []
	for n in config_dict.keys():
		config_list.append(n + " = " + config_dict[n] + "\n")
	config_list.sort()
	config_list.insert(0,config_list[-1])
	del config_list[-1]
	f= open(os.environ['HOME'] + '/.xpand','w')	
	f.writelines(config_list)	
	f.close	
		
def child_died_event(zvt):
	term.feed('Finished with all tracks.\n\r')
	widgets["ok"].set_sensitive(TRUE)

	
widgets = WidgetsWrapper()
# create the vscales
sbutton=[]
scale = []
adjustments=[]
for n in range(10, -1, -1):
	adjustment = GtkAdjustment(n*10, 0, 100, 1, 1, 0)
	adjustments.append(adjustment)
	scale.append(GtkVScale(adjustment))
	scale[10-n].set_usize(10, 80)
	scale[10-n].set_update_policy(UPDATE_CONTINUOUS)
	scale[10-n].set_digits(0)
	scale[10-n].set_draw_value(TRUE)
	widgets['hbox11'].pack_start(scale[10-n])
	scale[10-n].show()
	sbutton.append(GtkSpinButton(adjustment))
	sbutton[10-n].set_digits(0)
	sbutton[10-n].connect('changed',on_sbutton_changed)
	widgets['hbox11'].pack_start(sbutton[10-n])
	
# read config file
config_dict = {}
try:
	f= open(os.environ['HOME'] + '/.xpand')
except IOError:
	os.system("cp -f %s/share/xpand/.xpand %s" % (PREFIX, os.environ['HOME']))
	f= open(os.environ['HOME'] + '/.xpand')
config_list= f.readlines()
f.close
for line in config_list:
	if find(line, '=') == -1 or line[0] == '#':
		continue
	config_value = split(line,'=')
	config_value[0] = strip(config_value[0])
	config_value[1] = strip(config_value[1])
	config_dict[config_value[0]] = config_value[1]
if config_dict['source_dir'] == '%%home%%':
	config_dict['source_dir'] = os.environ['HOME']
if config_dict['dest_dir'] == '%%home%%':
	config_dict['dest_dir'] = os.environ['HOME']
set_levels(widgets['defaults'])
widgets['source_dir'].set_text(config_dict['source_dir'])
widgets['dest_dir'].set_text(config_dict['dest_dir'])
widgets['dev_path'].set_text(config_dict['dev_path'])

# create the zvterm
os.environ['TERM'] = 'xterm'
term = ZvtTerm(40, 15)
term.set_scrollback(100)
term.set_bell(TRUE)
term.set_scroll_on_keystroke(FALSE)
term.set_scroll_on_output(FALSE)
term.set_wordclass("-A-Za-z0-9/_:.,?+%=")
term.set_blink(FALSE)
font_name = "-misc-fixed-medium-r-semicondensed-*-*-120-*-*-c-*-iso8859-7"
term.set_font_name(font_name)
term.connect("child_died", child_died_event)
widgets["hbox6"].pack_start(term)
charwidth = term.charwidth
charheight = term.charheight
widgets['Xpand'].set_geometry_hints(geometry_widget=term,
		min_width=2*charwidth, min_height=2*charheight,
		base_width=charwidth,  base_height=charheight,
		width_inc=charwidth,   height_inc=charheight)
term.show()

scroll = GtkVScrollbar(term.adjustment)
widgets["hbox6"].pack_start(scroll, expand=FALSE)
scroll.show()

compress=widgets["compress"].get_active()
preset_name = ""

mainloop()
